﻿using System;
//using System.Collections.Generic;
//using System.Text;
using System.IO;
using System.Windows.Forms;
using Dizplay_Cruise;

namespace Dizplay_Cruise
{
    public class Globals
    {
        public static readonly long StartupTimeBinary = System.DateTime.Now.ToBinary();
        public static bool Locked = false;
        public static readonly string nl = Environment.NewLine;
        public static readonly string dnl = nl + nl;
        public enum xAlign { left, center, right }
        public enum yAlign { top, middle, bottom }
        /// <summary>
        /// Message Start
        /// </summary>
        public static readonly string MS = "^3» ";
        #region Files and folders

        public static readonly string DataFolder = Path.Combine(Application.StartupPath, "Dizplay");
        public static readonly string ApplicationFolder = Path.Combine(DataFolder, "Cruise");
        public static readonly string ConfigBackupFolder = Path.Combine(ApplicationFolder, "Global Config Backup");

        static public readonly string ConfigFile = Path.Combine(ApplicationFolder, "globalConfig.dz");
        static public readonly string RunningFile = Path.Combine(ApplicationFolder, "runningFile.dz");
        static public readonly string UserMarksFile = Path.Combine(ApplicationFolder, "userMarks.dz");
        static public readonly string SpecialSymbolsFile = Path.Combine(ApplicationFolder, "specSymb.dz");
        static public readonly string ConfigBackupFile = Path.Combine(ApplicationFolder, "globalConfigBackup(" + System.DateTime.Now + ").dz");

        public static Helpers.ItObj StartupFileFolderCheck()
        {
            clsHistory H = new clsHistory();
            H.Title = new Helpers.ItObj("File folder startup existance check + creation", Dizplay.History.Count);

            if (!Directory.Exists(DataFolder))
            {
                Directory.CreateDirectory(DataFolder);
                H.Text += "Directory created: DataFolder" + nl;
            }

            if (!Directory.Exists(ApplicationFolder))
            {
                Directory.CreateDirectory(ApplicationFolder);
                H.Text += "Directory created: ApplicationFolder" + nl;
            }

            if (!Directory.Exists(ConfigBackupFolder))
            {
                Directory.CreateDirectory(ConfigBackupFolder);
                H.Text += "Directory created: ConfigBackupFolder" + nl;
            }

            if (!File.Exists(ConfigFile))
            {
                File.Create(ConfigFile);
                H.Text += "File created: ConfigFile" + nl;
            }

            if (!File.Exists(RunningFile))
            {
                File.Create(RunningFile);
                H.Text += "File created: RunningFile" + nl;
            }

            if (!File.Exists(UserMarksFile))
            {
                File.Create(UserMarksFile);
                H.Text += "File created: UserMarksFile" + nl;
            }

            if (!File.Exists(SpecialSymbolsFile))
            {
                File.Create(SpecialSymbolsFile);
                H.Text += "File created: SpecialSymbolsFile" + nl;
            }

            H.Text += "-- Check completed --";

            Dizplay.History.Add(H);
            return H.Title;
        }

        #endregion

        /// <summary>
        /// Internet Protocol
        /// </summary>
        public static string rootIP = "127.0.0.1";
        /// <summary>
        /// Administration Password
        /// </summary>
        public static string rootAP = "";
        /// <summary>
        /// Port
        /// </summary>
        public static ushort rootPT = 29999;
        /// <summary>
        /// Auto Connect
        /// </summary>
        public static bool rootAC = false;
        /// <summary>
        /// MCI Interval
        /// </summary>
        public static uint rootMI = 500;
        public static TimeSpan rootInterval = new TimeSpan(0, 0, 0, 0, (int)rootMI);

        /// <summary>
        /// Has the database been accessible on the last connection attempt
        /// </summary>
        public static bool DBAccessible = true;
        /// <summary>
        /// When the History dropdown menu needs to update, it checks if the History count has changed first. This is the variable that holds the count record, from the last time, in which the dropdown has been updated.
        /// </summary>
        public static int LastHistoryCount = 0;

        /// <summary>
        /// The name of the server, without any LFS tag stripping
        /// </summary>
        public static string ServerName = "Unknown";
    }
}